﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Teigha.Core;
using Teigha.TD;

namespace MultiThreadedDumper
{
    class WireCADUpdater
    {

        /************************************************************************/
        /* Dump the BlockTable                                                  */
        /************************************************************************/
        public bool ContainsSysName(OdDbDatabase pDb, string sysname)
        {
            bool ret = false;
            MemoryTransaction mTr = MemoryManager.GetMemoryManager().StartTransaction(Thread.CurrentThread.ManagedThreadId);

            /**********************************************************************/
            /* Get a SmartPointer to the BlockTable                               */
            /**********************************************************************/
            OdDbBlockTable pTable = (OdDbBlockTable)pDb.getBlockTableId().safeOpenObject();

            /**********************************************************************/
            /* Dump the Description                                               */
            /**********************************************************************/
            //Console.WriteLine();
            //Console.WriteLine(pTable.isA().name());

            /**********************************************************************/
            /* Get a SmartPointer to a new SymbolTableIterator                    */
            /**********************************************************************/
            OdDbSymbolTableIterator pBlkIter = pTable.newIterator();

            /**********************************************************************/
            /* Step through the BlockTable                                        */
            /**********************************************************************/
            for (pBlkIter.start(); !pBlkIter.done(); pBlkIter.step())
            {
                /********************************************************************/
                /* Open the BlockTableRecord for Reading                            */
                /********************************************************************/
                OdDbBlockTableRecord pBlock = (OdDbBlockTableRecord)pBlkIter.getRecordId().safeOpenObject();
                if (pBlock == null) continue;
                if (!pBlock.isLayout()) continue;
                if (!pBlock.getName().ToLower().Contains("model")) continue;
                //if (!pBlock.hasAttributeDefinitions()) continue;
                //if (pBlock.xrefStatus() != XrefStatus.kXrfNotAnXref) continue;
                /********************************************************************/
                /* Dump the BlockTableRecord                                        */
                /********************************************************************/
                //Console.WriteLine();
                //Console.WriteLine((pBlock.isA().name()));
                //Console.WriteLine("Name = {0}", (pBlock.getName()));
                //Console.WriteLine("Anonymous = {0}", (pBlock.isAnonymous()));
                //Console.WriteLine("Comments = {0}", (pBlock.comments()));
                //Console.WriteLine("Origin = {0}", (pBlock.origin()));
                //Console.WriteLine("Block Insert Units = {0}", (pBlock.blockInsertUnits()));
                //Console.WriteLine("Block Scaling = {0}", (pBlock.blockScaling()));
                //Console.WriteLine("Explodable = {0}", (pBlock.explodable()));

                //OdGeExtents3d extents = new OdGeExtents3d();
                //if (OdResult.eOk == pBlock.getGeomExtents(extents))
                //{
                //    Console.WriteLine("Min Extents = {0}", (extents.minPoint()));
                //    Console.WriteLine("Max Extents = {0}", (extents.maxPoint()));
                //}
                //    Console.WriteLine("Layout = {0}", (pBlock.isLayout()));
                //Console.WriteLine("Has Attribute Definitions = {0}", (pBlock.hasAttributeDefinitions()));
                //Console.WriteLine("Xref Status = {0}", (pBlock.xrefStatus()));
                //if (pBlock.xrefStatus() != XrefStatus.kXrfNotAnXref)
                //{
                //    Console.WriteLine("Xref Path = {0}", (pBlock.pathName()));
                //    Console.WriteLine("From Xref Attach = {0}", (pBlock.isFromExternalReference()));
                //    Console.WriteLine("From Xref Overlay = {0}", (pBlock.isFromOverlayReference()));
                //    Console.WriteLine("Xref Unloaded = {0}", (pBlock.isUnloaded()));
                //}

               
                /********************************************************************/
                /* Get a SmartPointer to a new ObjectIterator                       */
                /********************************************************************/
                OdDbObjectIterator pEntIter = pBlock.newIterator();
                //these should be the entities of the model space
               // MemoryTransaction mTr2 = MemoryManager.GetMemoryManager().StartTransaction(Thread.CurrentThread.ManagedThreadId);
                /********************************************************************/
                /* Step through the BlockTableRecord                                */
                /********************************************************************/
                for (; !pEntIter.done(); pEntIter.step())
                {
                   

                    /**********************************************************************/
                    /* Get a SmartPointer to the Entity                                   */
                    /**********************************************************************/
                    //OdDbEntity pEnt = OdDbEntity.cast((OdDbObject)pEntIter.objectId().safeOpenObject());
                    //if (pEnt == null)
                    //    continue;
                    OdDbBlockReference insert = OdDbBlockReference.cast(pEntIter.objectId().safeOpenObject());
                    if (insert == null)
                        continue; //not an insert
                    var i = insert.attributeIterator();
                    while (!i.done())
                    {
                        var attribute = (OdDbAttribute)i.objectId().safeOpenObject(OpenMode.kForWrite);
                        if (attribute.tag().Equals("sysname", StringComparison.InvariantCultureIgnoreCase))
                        {
                            if (attribute.textString().Equals(sysname, StringComparison.InvariantCultureIgnoreCase))
                            {
                                attribute.setTextString("not Fred");

                                ret = true;
                                //goto cleanup;
                            }
                            else
                            {
                                attribute.setTextString("Fred");
                            }
                        }
                        
                        i.step();
                    }
                }
            }
            cleanup:
            //MemoryManager.GetMemoryManager().StopTransaction(mTr2);
            MemoryManager.GetMemoryManager().StopTransaction(mTr, Thread.CurrentThread.ManagedThreadId);
            if (pDb.isModified())
            {
                try
                {
                    pDb.writeFile(pDb.getFilename(), SaveType.kDwg, pDb.originalFileVersion(), true);
                    FileInfo fi = new FileInfo(pDb.getFilename());
                    Debug.Assert(fi.Length != 0, "Something bad has happened");
                }
                catch (OdError e)
                {
                    Console.WriteLine(string.Format("Error Saving: {0}", e.description()));
                }
                catch (Exception err)
                {
                    Console.WriteLine("\nUnexpected error.");
                    throw;
                }
            }
            return ret;
        }
    }
}
