﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Threading;
using System.Threading.Tasks;

using Teigha.Core;
using Teigha.TD;
using System.Diagnostics;
using MultiThreadedDumper;

namespace odaFirstTry
{
    class Program
    {
        // synchro object
        private static object sync = new object();

        class SystemServices : RxSystemServicesImpl
        {
            public SystemServices()
            {
                Teigha.Core.Globals.odActivate(ActivationData.userInfo, ActivationData.userSignature);
            }
        }
        static int openErrorCount = 0;
        static void Main(string[] args)
        {
            /////////////////////////////////////////////////////////////////////////////////////
            //BEFORE YOU RUN THIS
            //
            //SETUP:
            //Copy the Router.dwg file in the {BUILD DIR}\Drawings\Router.dwg 50 times
            //so that you are searching and updating 50 of the same drawing.
            //
            //EXECUTION:
            //This tool searches for an attribute in blockreferences with a TAG of SysName
            //When found, if the value != "FRED" it is changed to be "FRED". If value == "FRED" 
            //it is changed to be "NOT FRED".
            //
            //On the first run through you may see one or two 0 byte files written.
            //If not keep running the tool. It won't take too long until you write a 0 byte file.
            //
            //
            //////////////////////////////////////////////////////////////////////////////////////

            SystemServices systemServices = new SystemServices();

           
            Stopwatch sw = new Stopwatch();
            sw.Start();
            openErrorCount = 0;
            // get memory manager and start first transaction
            MemoryManager man = MemoryManager.GetMemoryManager();
            // when working with a multithreaded application it is recommended to specify thread id
            MemoryTransaction startTr = man.StartTransaction(Thread.CurrentThread.ManagedThreadId);

            // initialize services
               
            ExHostAppServices hostAppServices = new ExHostAppServices();
            hostAppServices.disableOutput(true);
            hostAppServices.setMtMode(1);
            TD_Db.odInitialize(systemServices);

            // obtain files to dump
            string[] dumpFiles = Directory.GetFiles(Path.Combine(Directory.GetCurrentDirectory(), "Drawings") , "*.dwg", SearchOption.TopDirectoryOnly);



            // create dump tasks - the same number as dumpFiles
            Task[] dumpTasks = new Task[dumpFiles.Length];
            for (int ctr = 0; ctr < dumpFiles.Length; ctr++)
            {
                dumpTasks[ctr] = DumpFile(dumpFiles[ctr], hostAppServices);
            }

            Task.WaitAll(dumpTasks);

            // stop transactio
            man.StopTransaction(startTr);
            man.StopAll();
            // perform unitialization
            TD_Db.odUninitialize();
            sw.Stop();
            Console.WriteLine("Searched {0} drawings", dumpFiles.Length);
            Console.WriteLine("Elapsed Time: {0} ", sw.Elapsed.ToString());
            Console.WriteLine("Error Count: {0}", openErrorCount.ToString());
           
            Console.ReadKey();
        }
        private static Task<int> DumpFile(string fileName, ExHostAppServices hostApp)
        {
            return Task.Factory.StartNew(() =>
            {
                MemoryTransaction dumpTr = MemoryManager.GetMemoryManager().StartTransaction(Thread.CurrentThread.ManagedThreadId);
                OdDbDatabase dumpDb = null;
                FileInfo fi = new FileInfo(fileName);
                lock (sync)
                {
                    try
                    {
                        dumpDb = hostApp.readFile(fileName);
                    }
                    catch (OdError err)
                    {
                        Console.WriteLine("Error Opening Drawing:  {0}", err.Message);
                        openErrorCount++;
                    }
                }
                if (null == dumpDb)
                {
                    Console.WriteLine("Error Opening DWG file {0} does not exist or is incorrect", (string)fileName);
                }
                else
                {
                   
                    WireCADUpdater updater = new WireCADUpdater();
                    Console.WriteLine(string.Format("Drawing: {0} contains the SysName {1} = {2}. File size = {3}", Path.GetFileName(fileName), "fred", updater.ContainsSysName(dumpDb, "fred"), fi.Length));
                }
                MemoryManager.GetMemoryManager().StopTransaction(dumpTr, Thread.CurrentThread.ManagedThreadId);
                return 0;
            });
        }
    }
}